/*** Procedure to run tests of predictability ***/

proc(3) = predtest(ret,pred,maxp);

local zcrit, p, n, T, r, x, Dx, Lx, Z, i, 
    coef, v, Sv2, varmat, SErho, e, psi, df, 
    rhogls, xbar, inter, mu, Zbar, resid, dfgls, 
    conf, u, beta, Sigma, Kurt, delta, norm, omega2, 
    normbeta, SEbeta, tstat, tbeta, cL, cU, 
    critL, critR, Qbeta, rhoL, rhoU, correct, rbar, pols, pgls,ip,cdf,cdfgls,alphahat,dhat,resinit,siginit,dmpred,dfnb;

zcrit = cdfni(.95);

/* Choose lag length p by BIC */

dhat=meanc(pred[2:rows(pred)]);
dmpred=pred-meanc(pred[2:rows(pred)]);
siginit=sqrt(dmpred[2:rows(pred)]'*dmpred[2:rows(pred)]/(rows(dmpred)-1));
alphahat=abs(pred[1]-dhat)/siginit;

p = bic(pred,maxp);
dfnb=dfnbbic(pred,p);

/* Sample size */

n = rows(ret);
T = n-p;

/* Create variables */

r = ret[p+1:n];
x = pred[p+1:n];
Dx = pred[p+1:n]-pred[p:n-1];

Lx = ones(T,1)~pred[p:n-1];

for i (1,p,1);
    if i==1;
        Z = Lx;
    else;
        Z = Z~(pred[p-i+2:n-i+1]-pred[p-i+1:n-i]);
    endif;
endfor;


/* Estimate AR(1) for predictor variable */

coef = x/Lx;
v = x-Lx*coef;

Sv2 = v'v/(T-2);

varmat = Sv2*invpd(Lx'Lx);
SErho = sqrt(varmat[2,2]);

/* Estimate AR(p) for predictor variable */

coef = Dx/Z;
e = Dx-Z*coef;

if p==1;
    psi = 0;
else;
    psi = coef[3:p+1];
endif;

/* Compute DF t-statistic */

varmat = (e'e)/(T-p-1)*invpd(Z'Z);

df = coef[2]/sqrt(varmat[2,2]);
cdf = Uconf(df,DFbelt,5);
cdf=coef[2]*T;


/* Compute DF-GLS statistic */

rhogls = 1-7/T;

xbar = pred[p] | pred[p+1:n]-rhogls*pred[p:n-1];
inter = 1 | (1-rhogls)*ones(T,1);

mu = xbar/inter;

Zbar = Z[.,2]-mu;

if p>1;
    Zbar = Zbar~Z[.,3:p+1];
endif;

coef = Dx/Zbar;
resid = Dx-Zbar*coef;

varmat = (resid'resid)/(T-p)*invpd(Zbar'Zbar);

dfgls = coef[1]/sqrt(varmat[1,1]);
cdfgls=coef[1]*T;

/* Compute 95% confidence interval for c and rho */

conf = zeros(1,4);

conf[3] = Lconf(dfgls,DFGLSbelt,5);
conf[4] = Uconf(dfgls,DFGLSbelt,5);

conf[1] = 1+conf[3]/T;
conf[2] = 1+conf[4]/T;


/* Predictive regression */

coef = r/Lx;
u = r-Lx*coef;

beta = coef[2];

/* Estimate covariance matrix */

Sigma = (u~e)'(u~e)/(T-2);

delta = Sigma[1,2]/sqrt(Sigma[1,1]*Sigma[2,2]);
norm = sqrt(Sigma[2,2]/Sigma[1,1]);

omega2 = Sigma[2,2]/(1-sumc(psi))^2;

/*
/* Estimate excess kurtosis */

Kurt = meanc((u~e)^4)./(meanc((u~e)^2)^2)-3*ones(2,1);
print Kurt';
*/

/* Compute point estimate and t-stat for beta */

normbeta = norm*beta;

varmat = Sigma[1,1]*invpd(Lx'Lx);
SEbeta = sqrt(varmat[2,2]);

tstat = beta/SEbeta;


/* Compute 90% confidence interval for beta using t-stat */

tbeta = zeros(1,4);

cL = BonLconf(df,DFbelt,-abs(delta),tconf[.,1]);
cU = BonUconf(df,DFbelt,-abs(delta),tconf[.,1]);
critL = BonLcrit(cL,cU,-abs(delta),tquantL);


cL = BonLconf(df,DFbelt,-abs(delta),tconf[.,2]);
cU = BonUconf(df,DFbelt,-abs(delta),tconf[.,2]);
critR = BonRcrit(cL,cU,-abs(delta),tquantR);


if delta<=0;
    tbeta[1] = norm*(beta-critR*SEbeta);
    tbeta[2] = norm*(beta-critL*SEbeta);
else;
    tbeta[1] = norm*(beta+critL*SEbeta);
    tbeta[2] = norm*(beta+critR*SEbeta);
endif;

cL = BonLconf(dfgls,DFGLSbelt,-abs(delta),tconfgls[.,1]);
cU = BonUconf(dfgls,DFGLSbelt,-abs(delta),tconfgls[.,1]);
critL = BonLcrit(cL,cU,-abs(delta),tquantL);


cL = BonLconf(dfgls,DFGLSbelt,-abs(delta),tconfgls[.,2]);
cU = BonUconf(dfgls,DFGLSbelt,-abs(delta),tconfgls[.,2]);
critR = BonRcrit(cL,cU,-abs(delta),tquantR);


if delta<=0;
    tbeta[3] = norm*(beta-critR*SEbeta);
    tbeta[4] = norm*(beta-critL*SEbeta);
else;
    tbeta[3] = norm*(beta+critL*SEbeta);
    tbeta[4] = norm*(beta+critR*SEbeta);
endif;

Qbeta = zeros(1,15);

/* Compute 90% confidence interval for beta using Q-stat and DF-GLS */

cL = BonLconf(dfgls,DFGLSbelt,-abs(delta),Qconf[.,1]);
cU = BonUconf(dfgls,DFGLSbelt,-abs(delta),Qconf[.,2]);

rhoL = 1+cL/T;
rhoU = 1+cU/T;

correct = (T-2)/2*Sigma[1,2]/sqrt(Sigma[2,2]*omega2)*(omega2/Sv2-1)*SErho^2;

/* At LOWER confidence interval for rho */

rbar = r-Sigma[1,2]/sqrt(Sigma[2,2]*omega2)*(x-rhoL*Lx[.,2]);

coef = rbar/Lx;

Qbeta[1] = norm*(coef[2]+correct-zcrit*sqrt(1-delta^2)*SEbeta);
Qbeta[2] = norm*(coef[2]+correct+zcrit*sqrt(1-delta^2)*SEbeta);

/* At UPPER confidence interval for rho */

rbar = r-Sigma[1,2]/sqrt(Sigma[2,2]*omega2)*(x-rhoU*Lx[.,2]);

coef = rbar/Lx;

Qbeta[3] = norm*(coef[2]+correct-zcrit*sqrt(1-delta^2)*SEbeta);
Qbeta[4] = norm*(coef[2]+correct+zcrit*sqrt(1-delta^2)*SEbeta);

/* Bonferroni confidence interval */

if delta<=0;
    Qbeta[5] = Qbeta[3];
    Qbeta[6] = Qbeta[2];
else;
    Qbeta[5] = Qbeta[1];
    Qbeta[6] = Qbeta[4];
endif;


/* Compute 90% confidence interval for beta using Q-stat and DF-OLS */

cL = BonLconf(df,DFbelt,-abs(delta),Qconfols[.,1]);
cU = BonUconf(df,DFbelt,-abs(delta),Qconfols[.,2]);

rhoL = 1+cL/T;
rhoU = 1+cU/T;

correct = (T-2)/2*Sigma[1,2]/sqrt(Sigma[2,2]*omega2)*(omega2/Sv2-1)*SErho^2;

/* At LOWER confidence interval for rho */

rbar = r-Sigma[1,2]/sqrt(Sigma[2,2]*omega2)*(x-rhoL*Lx[.,2]);

coef = rbar/Lx;

Qbeta[7] = norm*(coef[2]+correct-zcrit*sqrt(1-delta^2)*SEbeta);
Qbeta[8] = norm*(coef[2]+correct+zcrit*sqrt(1-delta^2)*SEbeta);

/* At UPPER confidence interval for rho */

rbar = r-Sigma[1,2]/sqrt(Sigma[2,2]*omega2)*(x-rhoU*Lx[.,2]);

coef = rbar/Lx;

Qbeta[9] = norm*(coef[2]+correct-zcrit*sqrt(1-delta^2)*SEbeta);
Qbeta[10] = norm*(coef[2]+correct+zcrit*sqrt(1-delta^2)*SEbeta);

/* Bonferroni confidence interval */

if delta<=0;
    Qbeta[11] = Qbeta[9];
    Qbeta[12] = Qbeta[8];
else;
    Qbeta[11] = Qbeta[7];
    Qbeta[12] = Qbeta[10];
endif;


/* Restricted to rho<=1 */

if delta>0;
    Qbeta[13] = miss(1,1);
else;
    rbar = r-Sigma[1,2]/sqrt(Sigma[2,2]*omega2)*Dx;

    coef = rbar/Lx;
    
    Qbeta[13] = norm*(coef[2]+correct-zcrit*sqrt(1-delta^2)*SEbeta);
endif;

Qbeta[14]=df;
Qbeta[15]=dfgls;

retp(p~delta~df~dfgls~conf~dfnb,tstat~normbeta~tbeta~Qbeta,alphahat);

endp;