/*** Compute LEFT critical value of test 
    given confidence interval for c and delta ***/

proc BonLcrit(cL,cU,d,quant);

local i, delta, Ndelta, dist1, dist2, crit;

/* Choose nearest delta in grid */

delta = seqa(-1,.025,40);
Ndelta = rows(delta);

i = 1;
do while (delta[i]<d) and (i<Ndelta);
    i = i+1;
endo;

dist1 = abs(delta[i-1]-d);
dist2 = abs(delta[i]-d);

if dist1<dist2;
    i = i-1;
endif;

/* Compute critical value */

crit = Lcrit(cL,cU,quant[i,.]');

retp(crit);

endp;
